Attribute VB_Name = "PackDocuments"
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'       This is a part of the source code for Pro/DESKTOP.
'       Copyright (C) 1999-2001 Parametric Technology Corporation.
'       All rights reserved.
'
'       File:PackNGo.bas
'
'       This utility provides a mechanism of bundling up all the drawing/design documents
'       necessary to support a drawing(.dra) or an assembly(.des) file,so that a logical
'       set of files can be packaged easily. The script operates on a saved active design/drawing
'       document and packages the dependent design/drawing documents for the active
'       design/drawing document. The Pack Directory dialog is modal, and users can not work
'       freely while the dialog is present. The user needs to enter a directory name in the
'       dialog box. A directory with the the given name is created and the relevant
'       design/drawing documents are packaged in the same directory.
'

'==================================================================================================================================
'       Global declarations

Option Explicit

Dim app As ProDESKTOP

Private uc1 As userCommand
Private uc2 As userCommand
Private ext As IProDExtensibility

Dim dirCount As Integer
Dim filesInCurrentDiectory As Collection

Private Declare Function packDirDialog Lib "PackDlg.dll" Alias "PackDirDlg" (ByVal dlgTitle As String, ByRef namestr As Variant) As Boolean
Public Sub OnStartUp()

    Set app = CreateObject("ProDESKTOP.Application")
    Set ext = app
    Set uc1 = ext.AddUserCommand(barDrawing, menuDrawingFile, -1, GetResourceString(56), "PackDocuments", "PackDocuments.PackDlg")
    uc1.setIdentifier 1000
    uc1.SetPrompt GetMenuItemLabel(56)
    uc1.SetAccelerator "Ctrl+Shift+K"
    
    Set uc2 = ext.AddUserCommand(barDesign, menuDesignFile, -1, GetResourceString(56), "PackDocuments", "PackDocuments.PackDlg")
    uc2.setIdentifier 1001
    uc2.SetPrompt GetMenuItemLabel(56)
    uc2.SetAccelerator "Ctrl+Shift+K"
End Sub

Public Sub OnCloseDown()
  
    Set app = GetApp
    Set ext = app
    Set uc1 = ext.GetUserCommand(barDrawing, menuDrawingFile, GetResourceString(56))
    Set uc2 = ext.GetUserCommand(barDesign, menuDesignFile, GetResourceString(56))
    ext.RemoveUserCommand uc1
    ext.RemoveUserCommand uc2
End Sub
'==================================================================================================================================

'       Main Subroutine for launching dialog for packing documents

Public Sub PackDlg()
        
        On Error GoTo errorHandler
        Dim titleName As String
        Let titleName = GetResourceString(101)

        Dim dirName As Variant
        Dim checkIfOK As Boolean
        checkIfOK = packDirDialog(titleName, dirName)
    
        If checkIfOK Then
                Dim ret1 As String
                ret1 = Dir(dirName, vbDirectory)
                If (ret1 <> "") Then
                        Exit Sub
                Else
                        PackFiles dirName
                End If
        Else
                Exit Sub
        End If
        On Error GoTo 0
Exit Sub
errorHandler:
    MsgBox GetResourceString(96)
    
End Sub

'==================================================================================================================================

'       Main Subroutine for packing documents

Private Sub PackFiles(dirName As Variant)

On Error GoTo errorHandler
        'Create a ProDESKTOP Application object
        Set app = CreateObject("ProDESKTOP.Application")
        app.SetVisible True

        Dim graphicDoc As GraphicDocument
        Set graphicDoc = app.GetActiveDoc
        
        If graphicDoc Is Nothing Then
                MsgBox (GetResourceString(104))
                Exit Sub
        End If
        
        If Not typeOfGraphicDoc(graphicDoc) Then
                MsgBox (GetResourceString(102))
                Exit Sub
        End If

        If (Not IsFileSaved()) Then
                MsgBox (GetResourceString(103))
                Exit Sub
        End If
        
        Call initializeGlobalVaribles

        'Create a batch file in the temp dir
        Dim tempDir As String, batchFile As String, fn As Integer
        tempDir = Environ("TEMP")
        batchFile = tempDir + "\packers.bat"
        fn = FreeFile

        'Create a directory specified in the file dialog box
        Dim dirNameList As Collection
        Set dirNameList = New Collection
        MkDir dirName
        dirNameList.Add Item:=dirName
        

        'Adding Contents.txt to the new directory
        Dim ContentsFile As String
        ContentsFile = dirName + "\Contents.htm"
        Dim cn As Integer
        cn = fn + 1

        'Open the batch file for output
        Open batchFile For Output As #fn
        'Open the contents file for output
        Open ContentsFile For Output As #cn

        Call contentsFileTable(cn, app.GetActiveDoc.GetContent.GetFile.GetName)

        'Check if the active document is a Drawing or a Design document
        Dim designSet As ObjectSet
        Set designSet = app.GetClass("ObjectSet").CreateAObjectSet

        If (TypeOf graphicDoc Is DrawingDocument) Then
                ProcessDrawingDocument graphicDoc, fn, cn, designSet, dirName, dirNameList
        Else
                If (TypeOf graphicDoc Is PartDocument) Then
                        ProcessDesignDocument graphicDoc, fn, cn, designSet, dirName
                End If
        End If

        Dim designCollection As New Collection
        explodeDesignSet designSet, designCollection

        ProcessCollection designCollection, fn, cn, dirName, dirNameList

        Print #fn, "del " + batchFile
        Close #fn
        
        Call contentsFileEndLines(cn)
        Close #cn

        Shell batchFile

        Do While Dir(batchFile) <> ""
                DoEvents
        Loop

        resetGlobalVaribles
        
        Call PackingOverMessage(app.GetActiveDoc.GetContent.GetFile.GetName, dirNameList)
        
        Exit Sub

errorHandler:
MsgBox GetResourceString(96)
Exit Sub

NoDocError:
        
        Dim msg1 As String
        Dim msg2 As String
        
        msg1 = GetResourceString(104)
        msg2 = GetResourceString(105)
        
        MsgBox msg1, vbCritical, msg2
        Exit Sub

End Sub

'==================================================================================================================================

'       This function outputs the given assembly document and returns a design set

Private Function ProcessDesignDocument(graphicDoc As GraphicDocument, fn As Integer, cn As Integer, designSet As ObjectSet, dirName As Variant)

        Dim titleName As String
        Dim FileName As String
        
        FileName = graphicDoc.GetDesign.GetFile.GetName
        titleName = Dir(FileName)
        
        Print #fn, CopyFile(FileName, dirName)
        PrintToContentsFile cn, FileName, titleName, dirName
               
        Dim componentSet As ObjectSet
        Set componentSet = graphicDoc.GetDesign.GetComponents

        Dim designInstance As aDesignInstance
        Dim originalDesign As aDesign

        Dim it As iterator
        Set it = app.GetClass("it").CreateAObjectIt(componentSet)

        it.start
        Do While it.IsActive
                Set designInstance = it.Current
                Set originalDesign = designInstance.GetOriginal
                designSet.AddMember originalDesign

                it.Next
        Loop

End Function

'==================================================================================================================================

'       This function outputs the main drawing document,format file and returns a design set

Private Function ProcessDrawingDocument(graphicDoc As GraphicDocument, fn As Integer, cn As Integer, designSet As ObjectSet, dirName As Variant, dirNameList As Collection)
        Dim sheetSet As ObjectSet
        Set sheetSet = graphicDoc.GetDrawing.GetSheets
        
        Dim it As iterator
        Set it = app.GetClass("it").CreateAObjectIt(sheetSet)
        
        Dim firstTime As Boolean
        firstTime = True
        it.start
        Do While it.IsActive
               ProcessADrawing graphicDoc.GetDrawing, it.Current, fn, cn, firstTime, designSet, dirName, dirNameList
        firstTime = False
        it.Next
        Loop
End Function

'==================================================================================================================================

'       This function processes the given aDrawing object ,outputs the main drawing document,
'       format file and returns a design set

Private Function ProcessADrawing(dwg As aDrawing, sheet As aSheet, fn As Integer, cn As Integer, firstTime As Boolean, designSet As ObjectSet, dirName As Variant, dirNameList As Collection)

        If Not sheet Is Nothing Then
                'Process all views first
                Dim viewSet As ObjectSet
                Set viewSet = sheet.GetViews
                Dim viewIterator As iterator
                Set viewIterator = app.GetClass("it").CreateAObjectIt(viewSet)
                viewIterator.start
                Do While viewIterator.IsActive
                        designSet.AddMember viewIterator.Current.GetDesign
                        viewIterator.Next
                Loop

                Dim titleName As String
                Dim FileName As String
                FileName = sheet.GetFile.GetName
                titleName = Dir(FileName)

                If firstTime Then
                        Print #fn, CopyFile(FileName, dirName)
                        PrintToContentsFile cn, FileName, titleName, dirName
                ElseIf dwg.GetFile.GetName <> FileName Then
                       OutputFile fn, cn, FileName, titleName, dirName, dirNameList
                End If

                'Process format
                If Not sheet.GetFormat Is Nothing Then
                    If dwg.GetFile.GetName <> sheet.GetFormat.GetFile.GetName Then 'refering to same drawing
                        ProcessADrawing dwg, sheet.GetFormat, fn, cn, False, designSet, dirName, dirNameList
                    End If
                End If
        End If

End Function

'==================================================================================================================================

'       This function outputs the given file names , title names in the batch file and the
'       Contents file.

Private Function OutputFile(fn As Integer, cn As Integer, FileName As String, titleName As String, dirName As Variant, dirNameList As Collection)

        Dim found As Boolean
        Let found = False
        Dim newDir As Variant
        newDir = dirName
        Dim file
        For Each file In filesInCurrentDiectory
                If Dir(file) Like titleName And FileName <> file Then 'if file title is same then create a new directoy in dependencies folder
                        found = True
                        Exit For
                End If
                If FileName Like file Then 'if file is already in current directoy
                        Exit Function
                End If
        Next
        
        If dirCount = 0 Then
                dirName = dirName + "\" + "dependencies"
                MkDir dirName
                dirNameList.Add Item:=dirName
                dirCount = dirCount + 1
                newDir = dirName
        Else
                If found Then
                        newDir = dirName + "\" + "dir" & CStr(dirCount)
                        MkDir newDir
                        dirNameList.Add item:=newDir
                        dirCount = dirCount + 1
                End If
        End If

        filesInCurrentDiectory.Add item:=FileName
       
        Print #fn, CopyFile(FileName, newDir)
        PrintToContentsFile cn, FileName, titleName, newDir
        
End Function

'==================================================================================================================================

'       This function iterates over the given design set and calls explodeDesign to explode each
'       design in the design set

Private Function explodeDesignSet(designSet As ObjectSet, designCollection As Collection)

        'Process all designs
        Dim designIterator As iterator
        Set designIterator = app.GetClass("it").CreateAObjectIt(designSet)

        Dim designDesign As aDesign

        designIterator.start
        Do While designIterator.IsActive
                Set designDesign = designIterator.Current
                explodeDesign designDesign, designCollection
                designIterator.Next
        Loop

End Function

'==================================================================================================================================

'       This function iterates over the given design recursively and adds all the corresponding
'       designs in the design Collection

Private Function explodeDesign(design As aDesign, designCollection As Collection)

        designCollection.Add Item:=design

        Dim componentSet As ObjectSet
        Set componentSet = design.GetComponents

        Dim componentsIterator As iterator
        Set componentsIterator = app.GetClass("it").CreateAObjectIt(componentSet)

        Dim componentInstance As aDesignInstance
        Dim componentDesign As aDesign

        componentsIterator.start
        Do While componentsIterator.IsActive
                Set componentInstance = componentsIterator.Current
                Set componentDesign = componentInstance.GetOriginal()
                explodeDesign componentDesign, designCollection
                componentsIterator.Next
        Loop

End Function

'==================================================================================================================================

'       This function sorts the designs from the given collection

Private Function ProcessCollection(designCollection As Collection, fn As Integer, cn As Integer, dirName As Variant, dirNameList As Collection)

        Dim found As Boolean
        Let found = False

        Dim index0 As Integer
        Dim index1 As Integer
        Dim index2 As Integer

        Dim exitFor As Boolean

        index0 = 1

        Do Until found
                For index1 = index0 To designCollection.Count
                        For index2 = 1 To index1 - 1
                                If (designCollection(index1) Is designCollection(index2)) Then
                                        designCollection.Remove (index2)
                                        index0 = index1
                                        exitFor = True
                                        Exit For
                                End If
                        Next index2
                        If exitFor Then
                                exitFor = False
                                Exit For
                        End If
                Next index1
                If (index1 = designCollection.Count + 1) Then
                found = True
                End If
        Loop
          
        If (TypeOf app.GetActiveDoc Is PartDocument) Then
            OutputProEPart fn, cn, app.GetActiveDoc.GetDesign, dirName, dirNameList
        End If
                        
        For index1 = 1 To designCollection.Count
            OutputFile fn, cn, designCollection(index1).GetFile.GetName, designCollection(index1).GetFile.GetTitle, dirName, dirNameList
            OutputProEPart fn, cn, designCollection(index1), dirName, dirNameList
        Next index1
       
End Function

'==================================================================================================================================

'       This function checks if the given document is a design document or a drawing document

Private Function typeOfGraphicDoc(graphicDoc As GraphicDocument) As Boolean

        If ((TypeOf graphicDoc Is DrawingDocument) Or (TypeOf graphicDoc Is PartDocument)) Then 'Exit if the active document is neither a drawing nor a design document
                typeOfGraphicDoc = True
        Else
                typeOfGraphicDoc = False
                Exit Function
        End If

End Function

'==================================================================================================================================

Private Function CopyFile(sourceFile As String, destFile As Variant)

        CopyFile = "if exist """ + sourceFile + """ copy """ + sourceFile + """ """ + destFile + """"
        
End Function

'==================================================================================================================================

Private Function contentsFileTable(cn As Integer, FileName As String)

        Print #cn, "<HTML>"
        Print #cn, "<HEAD>"
        Print #cn, "<TITLE>Contents</TITLE>"
        Print #cn, Spc(3), "</HEAD>"
        Print #cn, "<BODY>"
        Print #cn, "<TT>" + GetResourceString(108) + "</TT>"
        Print #cn, "<BR><TT>" + GetResourceString(109) + "</TT>"
        Print #cn, "<BR><TT>" + MakeString(GetResourceString(110), CStr(FileName)) + "</TT>"
        Print #cn, "<BR><TT></TT>&nbsp;"
        Print #cn, "<TABLE BORDER COLS=2 >"
        Print #cn, "<TR>"
        Print #cn, "<TD><B><TT>" + GetResourceString(111) + "</TT></B></TD>"
        Print #cn,
        Print #cn, "<TD><B><TT>" + GetResourceString(112) + "</TT></B></TD>"
        Print #cn, "</TR>"
        Print #cn,
        
End Function

'==================================================================================================================================

'       This function initializes the global variables

Private Function initializeGlobalVaribles()

        Let dirCount = 0
        Set filesInCurrentDiectory = New Collection
        
End Function

'==================================================================================================================================

'       This function resets the global variables

Private Function resetGlobalVaribles()

        Let dirCount = 0
        Set filesInCurrentDiectory = Nothing
        
End Function

'==================================================================================================================================

'       This function checks if a given document is saved.

Private Function IsFileSaved() As Boolean

        Dim FileName As String
        FileName = app.GetActiveDoc.GetContent.GetFile.GetName
        If FileName Like "" Then
            IsFileSaved = False
        Else
            IsFileSaved = True
        End If
        
End Function

'==================================================================================================================================

'This function displays a message after packing of the associated documents is done.

Private Function PackingOverMessage(FileName As String, dirNameList As Collection)

        Dim msg As String
        msg = GetResourceString(107)
                
        MsgBox (MakeString(msg, FileName, dirNameList.Item(1)))
        
End Function

'==================================================================================================================================

'This function displays adds the concluding lines to the contents.htm file.

Private Function contentsFileEndLines(cn As Integer)

        Print #cn, "</TABLE>"
        Print #cn, "<TT></TT>&nbsp;"
        Print #cn, "</BODY>"
        Print #cn, "</HTML>"
        
End Function

Private Function reverseString(name As String) As String
        
        Dim lengthOfName As Integer
        lengthOfName = Len(name)
        
        Dim LastWord As String
        Let LastWord = ""
        
        Dim Flag As Boolean
        Let Flag = True
        
        If lengthOfName = 0 Then
            Flag = False
        End If
        
        Do While Flag
            LastWord = LastWord + Mid(name, lengthOfName, 1)
            lengthOfName = lengthOfName - 1
            If lengthOfName = 0 Then
                Flag = False
            End If
        Loop

        reverseString = LastWord

End Function
Private Function OutputProEPart(fn As Integer, cn As Integer, design As aDesign, dirName As Variant, dirNameList As Collection)

        Dim proEPartName As String
        proEPartName = GetLatestVersion(design)
        
        If (proEPartName <> "") Then
            Dim proETitleName As String
            proETitleName = GetExtension(proEPartName, "\", True)
            OutputFile fn, cn, proEPartName, proETitleName, dirName, dirNameList
        End If
        
End Function

Private Function PrintToContentsFile(cn As Integer, FileName As String, titleName As String, dirName As Variant)
        
        Print #cn, "<TR>"
        Print #cn, "<TD><TT>" + FileName + "</TT></TD>"
        Print #cn, "<TD><TT>" + dirName + "\" + titleName + "</TT></TD>"
        Print #cn,
        Print #cn, "</TR>"
        Print #cn,
        
End Function

Private Function GetLatestVersion(design As aDesign) As String
        
        Dim opCount As Integer
        opCount = design.GetOperationCount
        Dim op As aOperation
        Dim PathName As String
        Let PathName = ""
        Dim i As Integer
        For i = 0 To opCount - 1
            Set op = design.GetOperation(i)
            If (op.IsA("ProEPart")) Then
              PathName = op.GetPathName
            End If
        Next i
        
        If PathName Like "" Then
            GetLatestVersion = ""
            GoTo endofFunction
        End If
        
        Dim directoryName As String
        directoryName = GetExtension(PathName, "\", False)
        
        PathName = PathName + ".*"
        
        Dim myFile As String, latestPathName As String
        Dim ext As Integer, latestVersion As Integer, version As Integer

        latestVersion = -1
        
        Dim Flag As Boolean
        Flag = True
        
        myFile = Dir(PathName)
        Do While Flag
            ext = GetExtension(myFile, ".", True)
            If CStr(ext) <> "" Then
                version = CInt(ext)
                If (version > latestVersion) Then
                    latestVersion = version
                    latestPathName = myFile
                End If
            End If
                            
            myFile = Dir
        
            If myFile <> "" Then
                Flag = True
            Else
                Flag = False
            End If
        Loop
                        
        GetLatestVersion = directoryName + latestPathName
        
endofFunction:

End Function

Private Function GetExtension(FileName As String, check As String, wantExtension As Boolean) As String
        
        Dim pos As Integer, newPos As Integer
        
        If FileName <> "" Then
            Dim reverseName As String
            reverseName = reverseString(FileName)
            pos = InStr(reverseName, check)

            Dim somestrr As String
            On Error Resume Next
            If wantExtension Then
                somestrr = Mid(reverseName, 1, pos - 1)
            Else
                newPos = Len(FileName) - pos + 1
                somestrr = Right(reverseName, newPos)
            End If
            On Error GoTo 0
            
            Dim title As String
            title = reverseString(somestrr)

            GetExtension = title
        Else
            GetExtension = ""
        End If
                
End Function

